/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

//Overly satisfying by nimitz (@stormoid)

//This might look like a lot of code but the base implementation of the gif itself is ~10loc

#define time iGlobalTime*2.6
#define pi 3.14159265

#define NUM 20.0
#define PALETTE vec3 (0.0, 1.4, 2.0) + 1.5

#define COLORED
#define MIRROR
#define ROTATE
//#define ROT_OFST
#define TRIANGLE_NOISE

//#define SHOW_TRIANGLE_NOISE_ONLY

float aspect = iResolution.x/iResolution.y;
float w = 50.0/sqrt(iResolution.x*aspect+iResolution.y);

float tri (in float x) { return abs(fract(x)-0.5); }
vec2  tri2(in vec2  p) { return vec2(tri(p.x+tri(p.y*2.0)),tri(p.y+tri(p.x*2.0))); }

mat2 mm2(in float a) { float c=cos(a), s=sin(a); return mat2(c,-s,s,c); }
mat2 m2 = mat2 ( 0.970, 0.242, -0.242, 0.970 );

//Animated triangle noise, cheap and pretty decent looking.

float triangleNoise(in vec2 p)
 {
   float z  = 1.5;
   float z2 = 1.5;
   float rz = 0.0;
   vec2  bp = p;

   for (int i=0; i<=3; i++ )
    {
      vec2 dg = tri2(bp*2.0) * 0.8 * mm2 ( time*0.3 );

      p += dg / z2;
      p *= 1.2 * m2;

      bp *= 1.6;
      z2 *= 0.6;
      z  *= 1.8;

      rz += ( tri ( p.x + tri(p.y)) ) / z;

    }

   return rz;
}

void main(void)
 {
   vec2 p = (gl_FragCoord.xy / iResolution.xy)*2.0 - 1.0;
   p.x *= aspect;
   float temp = p.x; // By rotating through 90 
   p.x = - p.y;      // degrees the heart is
   p.y = temp;       // now vertical and looks
   p*= 1.05;         // better. TheEmu.
    vec2 bp = p;

   #ifdef ROTATE
   p = p * mm2(time*.25);
   #endif

   float lp = length(p);
   float id = floor(lp*NUM+0.5) / NUM;

   #ifdef ROT_OFST
   p = p * mm2(id*11.0);
   #endif

   #ifdef MIRROR
   p.y = abs(p.y);
   #endif

   //polar coords
   vec2 plr = vec2 ( lp, atan(p.y,p.x) );

   //Draw concentric circles
   float rz = 1.0 - pow ( abs(sin(plr.x*pi*NUM))*1.25/pow(abs(w),0.25), 2.5 );

   //get the current arc length for a given id
   float enp = plr.y + sin((time+id*5.5))*1.52 - 1.5;
   rz *= smoothstep(0.0, 0.05, enp);

   //smooth out both sides of the arcs (and clamp the number)
   rz *= smoothstep(0.0,0.022*w/plr.x,enp) * step(id,1.0);
   #ifndef MIRROR
   rz *= smoothstep(-0.01,.02*w/plr.x,pi-plr.y);
   #endif

   #ifdef TRIANGLE_NOISE
   rz *= (triangleNoise(p/(w*w))*0.9+0.4);
   vec3 col = (sin(PALETTE+id*5.0+time)*0.5+0.5)*rz;
   col += smoothstep(0.4,1.0,rz) * 0.15;
   col *= smoothstep(0.2,1.0,rz) + 1.0;
   #else
   vec3 col = ( sin(PALETTE+id*5.0+time)*0.5 + 0.5 ) * rz;
   col *= smoothstep(0.8,1.15,rz)*0.7 + 0.8;
   #endif

   #ifndef COLORED
   col = vec3(dot(col,vec3(0.7)));
   #endif

   #ifdef SHOW_TRIANGLE_NOISE_ONLY
   col = vec3(triangleNoise(bp));
   #endif

   gl_FragColor = vec4(col,1.0);

 }